%%% "Modeling changes in US monetary policy using a time-varying nonlinear
%%% Taylor rule"
%%% Nguyen, Pavlidisz, and Peel

function [MEANFILTER,QUANTILE_L,QUANTILE_U,QUANTILE_2L,QUANTILE_2U]=Filterestimate(data)
% --------------------------- INPUT ---------------------------------
% Data

% --------------------------- OUTPUT ---------------------------------
% MEANFILTER: Estimates of state variables (Filtered)
% QUANTILE_L,QUANTILE_U: 68% quantiles
% QUANTILE_2L,QUANTILE_2U: 90 % quantile


% The time-invariant parameters estimated in the first step using function_cmaes in which the likelihood is derived using particle filter
load Estimates_results_orig xmean

param=xmean;

% Loading the data
r=data(:,2);
infl=data(:,3);
infv=data(:,4);
ug=data(:,5)   ;
T=size(r,1);
ns=6;



sig_sig=exp(param(1));
sig_rho=exp(param(2));
sig_c=exp(param(3));
sig_a=exp(param(4));
sig_b=exp(param(5));
sig_d=exp(param(6)); 

% Save
logl=zeros(T-1,1);
Neff=zeros(T-1,1);

% FOR LAW OF MOTION: 
load initialgridsearch_base
stateinitial=startpoint;
% the starting state values are used the same as those used in the estimation of time-invariant parameters
X0=[stateinitial(1); stateinitial(2); stateinitial(3); stateinitial(4); stateinitial(5); stateinitial(6)];


MVN=[sig_sig 0 0 0 0 0;
    0 sig_rho 0 0 0 0;
    0    0  sig_c 0 0 0;
    0  0 0 sig_a 0 0;
    0  0  0  0 sig_b 0;
    0  0  0   0   0 sig_d];

size1MVN=size(MVN,1);

% PARTICLE FILTERS
clevel=90;
clevel2=68;
N=10000;  
pos_res= 1; % 1=after resmpaling, 0 = before resampling  % It should be one so that we can use quantile. When using quantil, the weights are equal.


% Set state
randn('state', 039) 
rand('state',127)
randnumber=rand(T-1,1);
% Generate random samples at T=2
U=randn(ns,N);

% Update states
repmatX0=repmat(X0,1,N);

X= repmatX0 + MVN*U(1:(ns),:);

% IMPORTANCE WEIGHT
% Mean: Note that Inflation and UG are of time 2
RHO=exp(X(2,:))./(exp(X(2,:))+1);
Y=RHO*r(1)+(1-RHO).*(X(3,:)+X(4,:)*infl(2)+X(5,:)*infv(2)+X(6,:)*ug(2));
Yt=repmat(r(2),1,N);

weight = normpdf(Yt,Y,exp(X(1,:)));

% Likelihood
logl(1)=log(mean(weight));

%Normalizing
weight=weight/sum(weight);

if pos_res==1

% RESAMPLING
ind=resamplesys(weight,N,randnumber(1));



X1=X(:,ind);
weight=1/N;
SSS=[exp(X1(1,:)); exp(X1(2,:))./(exp(X1(2,:))+1);X1(3,:);X1(4,:); X1(5,:); X1(6,:)];

MEANFILTER=zeros(size1MVN,T-1);
VARFILTER=zeros(size1MVN,T-1);
QUANTILE_L=zeros(size1MVN,T-1);
QUANTILE_U=zeros(size1MVN,T-1);
QUANTILE_MED=zeros(size1MVN,T-1);
QUANTILE_2L=zeros(size1MVN,T-1);
QUANTILE_2U=zeros(size1MVN,T-1);
for j=1:(size1MVN)
MEANFILTER(j,1)=sum(weight.*SSS(j,:));
VARFILTER(j,1)=sqrt(sum(weight.*(SSS(j,:).^2))-MEANFILTER(j,1)^2);
QUANTILE_L(j,1)=quantile(SSS(j,:),(1-clevel/100)/2);
QUANTILE_U(j,1)=quantile(SSS(j,:),1-(1-clevel/100)/2);
QUANTILE_MED(j,1)=quantile(SSS(j,:),0.5);
QUANTILE_2L(j,1)=quantile(SSS(j,:),(1-clevel2/100)/2);
QUANTILE_2U(j,1)=quantile(SSS(j,:),1-(1-clevel2/100)/2);
end

elseif pos_res==0;  % filter before resample

   
    
X1=X;
SSS=[exp(X1(1,:)); exp(X1(2,:))./(exp(X1(2,:))+1);X1(3,:);X1(4,:); X1(5,:); X1(6,:)];
MEANFILTER=zeros(size1MVN,T-1);
VARFILTER=zeros(size1MVN,T-1);
QUANTILE_L=zeros(size1MVN,T-1);
QUANTILE_U=zeros(size1MVN,T-1);
QUANTILE_MED=zeros(size1MVN,T-1);
QUANTILE_2L=zeros(size1MVN,T-1);
QUANTILE_2U=zeros(size1MVN,T-1);
for j=1:(size1MVN)
MEANFILTER(j,1)=sum(weight.*SSS(j,:));
VARFILTER(j,1)=sqrt(sum(weight.*(SSS(j,:).^2))-MEANFILTER(j,1)^2);
QUANTILE_L(j,1)=quantile(SSS(j,:),(1-clevel/100)/2);
QUANTILE_U(j,1)=quantile(SSS(j,:),1-(1-clevel/100)/2);
QUANTILE_MED(j,1)=quantile(SSS(j,:),0.5);
QUANTILE_2L(j,1)=quantile(SSS(j,:),(1-clevel2/100)/2);
QUANTILE_2U(j,1)=quantile(SSS(j,:),1-(1-clevel2/100)/2);
end

% RESAMPLING
ind=resamplesys(weight,N,randnumber(1));
X1=X(:,ind);

end
    
    
for t=3:T
    
% Generate random samples at T=2
U=randn(ns,N);

% Update states

X= X1 + MVN*U(1:(ns),:);

% IMPORTANCE WEIGHT
% Mean: Note that Inflation and UG are of time 2
RHO=exp(X(2,:))./(exp(X(2,:))+1);
Y=RHO*r(t-1)+(1-RHO).*(X(3,:)+X(4,:)*infl(t)+X(5,:)*infv(t)+X(6,:)*ug(t));
Yt=repmat(r(t),1,N);

weight = normpdf(Yt,Y,exp(X(1,:)));

% Likelihood
logl(t-1)= log(mean(weight));


%Normalizing
weight=weight/sum(weight);

if pos_res==1;  % Filtered after resample
    
% RESAMPLING
ind=resamplesys(weight,N,randnumber(t-1));

X1=X(:,ind);
weight=1/N;
SSS=[exp(X1(1,:)); exp(X1(2,:))./(exp(X1(2,:))+1);X1(3,:);X1(4,:); X1(5,:); X1(6,:)];

for j=1:(size1MVN)
MEANFILTER(j,t-1)=sum(weight.*SSS(j,:));
VARFILTER(j,t-1)=sqrt(sum(weight.*(SSS(j,:).^2))-MEANFILTER(j,t-1)^2);
QUANTILE_L(j,t-1)=quantile(SSS(j,:),(1-clevel/100)/2);
QUANTILE_U(j,t-1)=quantile(SSS(j,:),1-(1-clevel/100)/2);
QUANTILE_MED(j,t-1)=quantile(SSS(j,:),0.5);
QUANTILE_2L(j,t-1)=quantile(SSS(j,:),(1-clevel2/100)/2);
QUANTILE_2U(j,t-1)=quantile(SSS(j,:),1-(1-clevel2/100)/2);
end

%elseif pos_res==0  % filter before resample
    
 %X1=X;
%SSS=[exp(X1(1,:)); exp(X1(2,:))./(exp(X1(2,:))+1);X1(3,:);X1(4,:); X1(5,:); X1(6,:)];
%for j=1:(size1MVN)
%MEANFILTER(j,t-1)=sum(weight.*SSS(j,:));
%VARFILTER(j,t-1)=sqrt(sum(weight.*(SSS(j,:).^2))-MEANFILTER(j,t-1)^2);
%QUANTILE_L(j,t-1)=quantile(SSS(j,:),(1-clevel/100)/2);
%QUANTILE_U(j,t-1)=quantile(SSS(j,:),1-(1-clevel/100)/2);
%QUANTILE_MED(j,t-1)=quantile(SSS(j,:),0.5);
%QUANTILE_2L(j,t-1)=quantile(SSS(j,:),(1-clevel2/100)/2);
%QUANTILE_2U(j,t-1)=quantile(SSS(j,:),1-(1-clevel2/100)/2);
%end


% RESAMPLING
%ind=resamplesys(weight,N,randnumber(t-1));
%X1=X(:,ind);

end

end

